*-----------------------------------------------------------
* Program    :
* Written by :
* Date       :
* Description:	Vec
*-----------------------------------------------------------
*
	OFFSET	0
VecPrv	 DS.L	1	* Pointer to Previous Vec, 0 for 1st one defined.
VecESz	 EQU	*	* Overloaded onto 2 LS bits of VecDWSz
VecDWSz	 DS.W	1	* Declared size this vec in words; low order 2 bits known 0 so overloaded
VecDSMsk EQU	$FFFC	* Mask to purify out DWdz from ESz
VecESMsk EQU	$0003	* Mask to purify out ESz form DWSz
Vec_ELSZ_BYT	EQU 0   * Vec Elts are bytes, allocated 8 at a time
Vec_ELSZ_WRD	EQU 1   * Vec Elts are words, allocated 4 at a time
Vec_ELSZ_LNG	EQU 2   * Vec Elts are longs, allocated 2 at a time
Vec_ELSZ_DBL	EQU 3   * Vec Elts are doubles, allocated 1 at at time
VecCrIx	 DS.W	1	* Index of last used element in vector now, should be zero to end
VECEMPTYIX EQU	-1	* ix -1 means empty vector, vecptr = 0 means no vector
VEC_HDR_WDS	EQU */WRDBYTS
VEC_HDR_BYTS	EQU VEC_HDR_WDS+VEC_HDR_WDS
VecData	 EQU	*	* Vector data starts here, at least one dbl, alloc'd a dbl at a time
	 ORG	*
*
VEC_CMP_LESS	EQU -1
VEC_CMP_EQL	EQU 0
VEC_CMP_GRTR	EQU 1
*
*	================= VecPrev(v:VecPtr): VecPtr ========================
VecPrev:	* ALTERS a0,d0, null OK, dbls OK  
	move.l	-MARKBYTS(a6),a0	* v
	move.l	a0,d0		* result = v in case v null
	move.l	d0,(a6)
	beq	vp1		* in case null
	move.l	(a0),(a6)	* v^.prev overwrites result in situ
vp1:
	rts
*
*	================= VecLast():VecPtr ============================
VecLast:	* ALTERS none, null ok, dbls OK
	move.l	a2,(a6)
	rts
*
*	================== VecDclWdSz (v:VecPtr):unsigned long; ==========
VecDclWdSz:	* ALTERS a0,d0, null OK, dbls OK
	move.l	-MARKBYTS(a6),a0	* v
	move.l	a0,d0		* in case v null
	beq	vd1
	move.w	VecDWSz(a0),d0	* v^.VecDclWdSz
	and.l	#VecDSMsk,d0	*Clear out the ElSz bits 
vd1:
	move.l	d0,(a6)		* overwrite result in situ
	rts
*
*	========== VecCalcDWSz (etyp:long, cnt:long):long ===============
*	etype <> VEC_ELSZ_BYT, VEC_ELSZ_WRD, VEC_ELSZ_LNG
*	assumed to be VEC_ELSS_DBL
VecCalcDWSz:	* ALTERS d0,d1, null OK, dbl OK
	OFFSET	0
_vcdw_Result	DS.L	1
_vcdw_Prev	DS.L	1
_vcdw_cnt	DS.L	1
_vcdw_etyp	DS.L	1
_vcdw_RetPC	DS.L	1
	ORG	*
	move.l	-_vcdw_etyp(a6),d0	* etyp
	move.l	-_vcdw_cnt(a6),d1	* cnt
	cmpi.l	#VEC_ELSZ_BYT,d0
	bne	vcd1
	addi.l	#DBLBYTS-1,d1		* round up to dbl mult
	lsr.l	#3,d1			* bytes to dbls
	bra	vcd3
vcd1:
	cmpi.l	#VEC_ELSZ_WRD,d0
	bne	vcd2
	addi.l	#DBLWRDS-1,d1		* round up to dbl mult
	lsr.l	#2,d1			* wds to dbls
	bra	vcd3
vcd2:
	cmpi.l	#VEC_ELSZ_LNG,d0
	bne	vcd3
	addi.l	#DBLLNGS-1,d1		* round up to dbl mult
	lsr.l	#1,d1			* longs to dbls
vcd3:
	lsl.l	#2,d1			* dbls to wds
	addi.l	#VEC_HDR_WDS,d1
	move.l	d1,-_vcdw_Result(a6)
	rts
*
*	=============== VecElSz (v:VecPtr):unsigned long; ================
VecElSz:	* ALTERS a0,d0, null ok, dbl OK
	move.l	-MARKBYTS(a6),a0 * v
	move.l	a0,d0		* return 0 if v null
	move.l	d0,(a6)
	beq	ve1		* in case null
	move.w	VecESz(a0),d0	* v^.ElSz
	and.l	#VecESMsk,d0		* clear out the highorder bits
	move.l	d0,(a6)		* overwrite result in situ
ve1:
	rts
*
*	================= VecMaxIx (v:vecptr):unsigned long; ================
*	ALTERS: a0,d0,d1, null OK, dbl OK
VecMaxIx:
	OFFSET	0
_vmxResult	DS.L	1
_vmxPrvFrm	DS.L	1
_vmxv		DS.L	1
_vmxRetPC	DS.L	1
_vmxt		DS.L	1
_vmxs		DS.L	1
	ORG	*
*	if v=0 then return 0;
	tst.l	-_vmxv(a6)
	bne 	vm1a
		clr.l	-_vmxResult(a6)
		rts
vm1a:
*	t=VecDclWdSz(v)-VEC_HDR_WDS;
	halfmark
		move.l	-_vmxv(a6),-(a7)	
		lea.l	MARKBYTS(a7),a6
		lea.l	VecDclWdSz,a0
		jsr	(a0)
	unmark					* t allocated in tos
	subq.l	#VEC_HDR_WDS,(a7)		* subtract hdr wds from wdsz
*	s = VecElSz(v);
	halfmark
		move.l	-_vmxv(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecElSz,a0
		jsr	(a0)
	unmark					* s allocated in tos
	move.l	(a7)+,d0			* d0=s
	move.l	(a7)+,d1			* d1=t
*	if s=0 then
	tst.l	d0
	bne	vm0
*		t=t+t				* byt cnt is dbl wdsz
		add.l	d1,d1
*	endif
	bra	vm3
vm0:
*	else if s=1 then			* wd cnt is wdsz
	cmpi.l	#1,d0
	beq	vm3
*	else if s=2 then t >> 1			* long cnt is 1/2 wdsz
	cmpi.l	#2,d0
	bne	vm1
*		t >> 1
		asr.l	#1,d1
*	else  t>>2				* dbl cnt is 1/4 wdsz
	bra	vm3
vm1:
	asr.l	#2,d1
vm3:
*	t = t - 1				* index is 0-rel
	subq.l	#1,d1
*	return t
	move.l	d1,(a6)
	move.l	-_vmxRetPC(a6),a0
	jmp	(a0)
*		
*	====================== VecCurIx (v:VecPtr):unsigned long; ================
VecCurIx:	* ALTERS a0,a1,d0, null OK, dbl OK
	move.l	-MARKBYTS(a6),d0	* v
	move.l	d0,a0		* if null then return VECEMPTYIX
	bne	vci1
		move.l	#VECEMPTYIX,(a6) * null vector's result is VECEMPTYIX
		rts
vci1:
	clr.l	d0
	move.w	VecCrIx(a0),d0	* v^.ElSz
	ext.l	d0		* sign extend to 32 bits
	move.l	d0,(a6)		* overwrite result in situ
	rts
*
*	============== VecSetCurIx (v:VecPtr, i:unsigned long):vecptr; =============
VecSetCurIx:	* ALTERS a0,d0,d1, null OK, dbl OK
	move.l  -MARKBYTS(a6),d0 * v
	move.l	d0,a0
	beq	vsci1		* no op if v null
	move.l	-(MARKBYTS+LNGBYTS)(a6),d1 * i
	move.w	d1,VecCrIx(a0)	* v^.VecCrIx = i
vsci1:	
	move.l	d0,(a6)		* overwrite result in situ
	rts
*
*	======================= VecEltI(v:VecPtr, ==================================
*		i:unsigned short,val:bool):long (or dbl if type is dbl)
VecEltI:	* ALTERS a0,a1,d0,d1,d2, null OK, dbl OK
*	* Dbl caller obliged to push extra long before mark for loworder long of dbl
       move.l 	(a7)+,a0   * ret pc
       move.l 	(a7)+,d2   * val=t,adr=f
       move.l 	(a7)+,d1   * i
       move.l 	(a7)+,a1   * v
       clr.l    (a6)	   * pre-clear result
       move.l	a1,d0
       tst.l	d0         * if v null then return 0
       bne	vei1
       jmp	(a0)
vei1:	
       tst.l	d2	   * adr=0,val<>0
       beq 	veceladr   * Name call
       move.w	VecESz(a1),d0   * v^.ElSz
       and.l	#VecESMsk,d0
       subq	#1,d0
       bge	vecel1	   * byte vec index is just i
       tst.l	d2	   * adr=0,val<>0
       beq 	veceladr   * Name call
       move.b  	VecData(a1,d1),LNGBYTS-1(a6) * byte vec elt
       bra 	endveci
veceladr:
       lea.l    VecData(a1,d1),a1
       move.l   a1,(a6)
       bra 	endveci
vecel1:
       add.l	d1,d1	   * word,long,dbl vec so we dbl i
       subq	#1,d0
       bge	vecel2
       tst.l	d2	   * adr=0,val<>0
       beq 	veceladr   * Name call
       move.w	VecData(a1,d1),2(a6) *wd vec elt 
       bra 	endveci
vecel2:
       add.l 	d1,d1	   * long, dbl vec so we dbl i
       subq	#1,d0
       bge	vecel3
       tst.l	d2	   * adr=0,val<>0
       beq 	veceladr   * Name call
       move.l   VecData(a1,d1),(a7) * long vec elt
       bra	endveci
vecel3:
       add.l	d1,d1	   * dbl vec so we dbl i
       tst.l	d2	   * adr=0,val<>0
       beq 	veceladr   * Name call
       move.l  	DBLBYTS(a1,d1),(a6) * dbl vec elt
       move.l 	VecData(a1,d1),LNGBYTS(a6) * so dbl result pushed
endveci:
       jmp (a0)
*
*	=== VecNew(data:...,datap:ptr,prev: VecPtr, dclwdsz: unsigned short; elttyp: 0..3, ===
*		initcurinx: unsigned short): VecPtr \\Elt 0 always exists unless datap=0
VecNew:		* ALTERS: a0,a1,d0,d1,d2,d3, null OK, dbl OK
	move.l	(a7)+,d3	* pc for return
	move.l	(a7)+,d2	* initcurinx 
	move.l	(a7)+,d0	* elttyp
	move.l	(a7)+,d1	* dclwdsz
	move.l	(a7)+,a0	* prev
	move.l	(a7),a1	        * ptr to 1st unpacked long of stack data	
*
	move.l	a4,a2		* VecLst=Avail
	move.l	a0,(a4)+	* new^.prev=prev
	and.l	#VecDSMsk,d1	* be sure loworder 2 clear
	and.l	#VecESMsk,d0	* be sure highorder 30 clear
	or.w	d0,d1		* merge them
	move.w	d1,(a4)
	move.w	d2,2(a4)
	addq	#WRDBYTS+WRDBYTS,a4 * keep avail long aligned pointing past 2 long hdr
*	
*	Handle data-less case with datap=null
	tst.l	(a7)
	bne	vecnewdata
morenodata:
		clr.l	(a4)
		clr.l	LNGBYTS(a4)
		addq	#DBLBYTS,a4	* Double containing next elt allocated and cleared
		subq.l	#DBLWRDS,d1
		ble	vecdone
	bra	morenodata	* Need to clear out four more and test whether to allocate
vecnewdata:
*	Move the unpacked data from stack to data allocating as we go
* 	Data is on the stack in reverse order!
	tst.l	d0
	bne	typ1
	addq	#3,a1	* A1 points to loworder byte in long on stack
*	Move unpacked bytes from stack to data, allocating in chunks of 8 with zero fill
moretype0:	* Clear out the next 8 bytes to be allocated just in case needed
	move.l	a4,a0
	clr.l	(a4)
	clr.l	LNGBYTS(a4)
	addq	#DBLBYTS,a4		* Double containing next elt allocated and cleared
	tst.l	d2
	blt	vecdone		* No more to allocate or move
	move.b	(a1),(a0)+	* Move elt 0
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone	
	move.b	(a1),(a0)+	* Move elt 1
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.b	(a1),(a0)+	* Move elt 2
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.b	(a1),(a0)+	* Move elt 3	
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone	
	move.b	(a1),(a0)+	* Move elt 4
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.b	(a1),(a0)+	* Move elt 5
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.b	(a1),(a0)+	* Move elt 6
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.b	(a1),(a0)+	* Move elt 7
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	bra	moretype0	* Need to clear out four more and test whether to allocate
typ1:	cmp.l	#1,d0
	bne	typ2
	addq	#2,a1
*	Move unpacked words from stack to data, allocating in chunks of 4 with zero fill
moretype1:	* Clear out the next 4 words to be allocated just in case needed
	move.l	a4,a0
	clr.l	(a4)
	clr.l	LNGBYTS(a4)
	addq	#DBLBYTS,a4		* Double containing next elt allocated and cleared
	tst.l	d2
	blt	vecdone		* No more to allocate or move
	move.w	(a1),(a0)+	* Move elt 0
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.w	(a1),(a0)+	* Move elt1
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.w	(a1),(a0)+	* Move elt2
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.w	(a1),(a0)+	* Move elt3
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	bra	moretype1	* Need to clear out four more and test whether to allocate
typ2:	cmp.l	#2,d0
	bne	typ3
*	Move longs from stack to data, allocating in chunks of 2 with zero fill
moretype2:	* Clear out the next 2 longs to be allocated just in case needed
	move.l	a4,a0
	clr.l	(a4)
	clr.l	LNGBYTS(a4)
	addq	#DBLBYTS,a4		* Double containing next elt allocated and cleared
	tst.l	d2
	blt	vecdone		* No more to allocate or move
	move.l	(a1),(a0)+	* Move elt 0
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	move.l	(a1),(a0)+	* Move elt 1
	subq	#LNGBYTS,a1
	subq	#1,d2
	blt	vecdone
	bra	moretype2	* Need to clear out two more and test whether to allocate
typ3:	
*	Move doubles from stack to data, allocating 1 at a time with no zero fill
	tst.l	d2
	blt	vecdone
	move.l	(a1),(a4)+	* Move elt 0 highorder half
	subq	#LNGBYTS,a1
	move.l	(a1),(a4)+	* Move elt 0 loworder half
	subq	#LNGBYTS,a1
	subq	#1,d2
	bge	typ3
vecdone:
	move.l	a2,(a6)		* Result updated in situ
	move.l	d3,a0		* Ret pc
	jmp	(a0)
*
*
*	============== VecCpy	( s: vecptr, d: vecptr ): vecptr ===================
*	Returns d; no-op if d too short or elt types mismatch
VecCpy:	* 			Alters a0,a1,d0,d1; null OK, dbl OK
	OFFSET	0
_vc_Result	DS.L	1
_vc_PrvFrm	DS.L	1
_vc_s		DS.L	1
_vc_d		DS.L	1
_vc_RetPC	DS.L	1
_vc_styp	DS.L	1
_vc_dtyp	DS.L	1
_vc_scurix	DS.L	1
_vc_dcurix	DS.L	1
	ORG	*
*
	move.l	-_vc_d(a6),(a6)			* always return d
	tst.l	-_vc_s(a6)			* null s is no-op
	beq	vcdone
	tst.l	-_vc_d(a6)			* null d is no-op
	beq	vcdone
	halfmark
		move.l	-_vc_s(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecElSz,a0
		jsr	(a0)
	unmark					* styp allocated in tos
	halfmark
		move.l	-_vc_d(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecElSz,a0
		jsr	(a0)
	unmark					* dtyp allocated in tos
	move.l	-_vc_styp(a6),d1
	move.l	-_vc_dtyp(a6),d0
	cmp.l	d0,d1
	bne	vcdone				* mismatch is no-op
	halfmark
		move.l	-_vc_s(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark					* scurix allocated in tos
	halfmark
		move.l	-_vc_d(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecMaxIx,a0
		jsr	(a0)
	unmark					* dcurix allocated in tos
	move.l	-_vc_dcurix(a6),d1
	move.l	-_vc_scurix(a6),d0
	cmp.l	d0,d1
	blt	vcdone				* d too short is no-op
	halfmark
		move.l	-_vc_s(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecDclWdSz,a0
		jsr	(a0)
	unmark					* source wd count in tos
	move.l	-_vc_s(a6),a0
	addq.l	#VEC_HDR_BYTS,a0
	move.l	-_vc_d(a6),a1
	addq.l	#VEC_HDR_BYTS,a1
	move.l	(a7)+,d0			* pop word count to d0
	subq.l	#VEC_HDR_WDS+1,d0		* words to move not counting header
vcmore:
		move.w	(a0)+,(a1)+
	dbf	d0,vcmore			* ends when count goes to -1	
	halfmark				* d's curix to val from s
		move.l	-_vc_scurix(a6),-(a7)
		move.l	-_vc_d(a6),-(a7)
		lea.l	MARKBYTS+LNGBYTS(a7),a6
		lea.l	VecSetCurIx,a0
		jsr	(a0)
	unmark
vcdone:
	lea.l	-_vc_RetPC(a6),a0
	jmp	(a0)
*
*
* ==================== VecMid(s:vecptr, stix:long, c: long):vecptr ===================
VecMid:		* ALTERS a0,a1,d0,d1,d2,d3; null ok, dbl ok
*   Stix is starting index of first element to return; 
*   C is numeric expression indicating how many elements to return in new vec.
*   Returns null if s null; if stix > curix of s then null is returned.
*   If stix <= curix of s then a new vector consisting of c elements from stix to min(stix+c-1,curix) 
*   is returned. If c<=0 then null is returned.
	OFFSET	0
_vl_Result	DS.L	1
_vl_PrevFrm	DS.L	1
_vl_s		DS.L	1
_vl_stix	DS.L	1
_vl_c		DS.L	1
_vl_RetPC	DS.L	1
_vl_elsz	DS.L	1
_vl_newv	DS.L	1
_vl_eltlow	DS.L	1
_vl_elt		DS.L	1
	ORG	(*+3)&-4
*
*	d0 = null
	clr.l	d0
*	if (d3=c) <= 0 then goto vlret
	move.l	-_vl_c(a6),d3
	ble	vlret
*	if s == null then return d0
	move.l	-_vl_s(a6),d2
	beq	vlret
*	d2 = VecCurIx(s)
	mark
	  move.l	d2,-(a7)
	  lea.l		VecCurIx,a0
	  jsr		(a0)
	unmark
	move.l	(a7)+,d2		* stk as at call
*	if stix > d2 then goto vlret
	move.l	-_vl_stix(a6),d1	* stix
	cmp.l	d2,d1
	ble	vldo
vlret:
*	return d0
	move.l		d0,(a6)
	move.l		-_vl_RetPC(a6),a0
	jmp		(a0)
vldo:
*	\\ Move elements from stix through c=min(curix,c+stix-1)
*	if c+stix-1 <= curix then
	move.l		d3,d0		* c
	add.l		d1,d0		* c+stix
	subq.l		#1,d0		* c+stix-1
	cmp.l		d0,d2		* curix
	blt		vld1
*	  c=curix-stix+1
	  move.l	d2,d3		* curix
	  sub.l		d1,d3		* -stix
	  addq.l	#1,d3		* +1
	  move.l	d3,-_vl_c(a6)	* into c
*	endif
vld1:
	move.l 		-_vl_s(a6),a0		
	mark
	  move.l	a0,-(a7)	* v
	  lea.l		VecElSz,a0
	  jsr		(a0)
	unmark				* Elsz allocated in tos
	move.l		(a7),d2		* Elsz
	mark
	  move.l	d2,-(a7)	* Elsz
	  move.l	d3,-(a7)	* c
	  lea.l		VecCalcDWSz,a0
	  jsr		(a0)
	unmark				* DclWdSz in tos
	move.l		(a7)+,d3	* DclWdSz
	move.l 		-_vl_c(a6),d0	* ix=c-1
	subq.l		#1,d0
	mark
	  clr.l		-(a7)      		* datap
	  move.l	a2,-(a7)   		* prev
	  move.l	d3,-(a7)   		* DclWdSz
          move.l	d2,-(a7)   		* ElSz
	  move.l	d0,-(a7)   		* Ix
	  lea.l		VecNew,a0
	  jsr		(a0)
        unmark					* newv in tos
*
*	drop=VecSetCurIx(newv,-1)
	halfmark
		move.l	-_vl_newv(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		move.l	#-1,-(a7)
		lea.l	VecSetCurIx,a0
		jsr	(a0)
	unmarkdrop
*
*	repeat
vllp:	* stack at call but has elsz, and newv added over retpc; c is cnt-1 of elts remaining to move
*	    tos = 0
	    clr.l		-(a7)		* always allocate eltlow in tos
vl1:
*	  tos=VecEltI(v,stix,true);
	  halfmark
		move.l	-_vl_s(a6),-(a7)	* v
	    	move.l	-_vl_stix(a6),d0 	* stix
		lea.l	MARKBYTS+LNGBYTS(a7),a6	* new frm
		move.l	d0,-(a7)		* stix
		moveq.l	#1,d0			
		move.l	d0,-(a7)		* val=true
		lea.l	VecEltI,a0
		jsr	(a0)
	  unmark					* elt,eltlow,newv,dclwdsz,elsz
*
*	  drop = VecAppend(newv,eltlow,elt)
  	  halfmark
		move.l	-_vl_newv(a6),-(a7)  	* newv
		move.l	-_vl_eltlow(a6),-(a7)	* loworder elt
		move.l	-_vl_elt(a6),-(a7)  	* elt
		lea.l	MARKBYTS+LNGBYTS+LNGBYTS(a7),a6 * new frm
		lea.l	VecAppend,a0
		jsr	(a0)
	  unmarkdrop
	  lea.l	LNGBYTS+LNGBYTS(a7),a7		* drop elt, eltlow
*	  stix ++
	  move.l	-_vl_stix(a6),d0	* i
	  addq.l	#1,d0
	  move.l	d0,-_vl_stix(a6)
*	until c-- <= 0
	move.l	-_vl_c(a6),d0
	subq.l	#1,d0
	move.l	d0,-_vl_c(a6)
	bgt	vllp
	move.l	-_vl_newv(a6),d0
	bra	vlret 	
*
*
* ============= VecNxt(s:vecptr,start:long,,mchlow:long, match:long):long =========
*   ALTERS a0,a0,d0,d1,d2; null ok, dbl ok
*   Returns null if s null; 
*   returns ix if VecCurIx(s) < 0, 
*   returns ix-st if ix < start,
*   returns -1 if no match in s from start on,
*   returns ix of 1st match in s[start]..s[curix]
VecNxt:
	OFFSET	0
_vn_Res	DS.L	1
_vn_Prv	DS.L	1
_vn_s	DS.L	1
_vn_st	DS.L	1
_vn_mchlow DS.L	1
_vn_mch	DS.L	1
_vn_RetPC DS.L	1
_vn_elsz DS.L	1
_vn_ix	DS.L	1
_vn_eltlow DS.L	1
_vn_elt	DS.L	1
	ORG	*
*
*	if s == null then return s
	move.l	-_vn_s(a6),d0
	beq	vnret
*
	mark
		move.l d0,-(a7)
		lea.l	VecElSz,a0
		jsr	(a0)
	unmark					* elsz allocated in tos
*
*	ix = VecCurIx(s)
	mark
		move.l	d0,-(a7)
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark					* ix allocated in tos
*	if ix <= 0 then goto vlret
	move.l	(a7),d0
	blt	vlret
*	if st > ix then goto vlret
	move.l	-_vn_st(a6),d2			* st
	move.l	d0,d1				* ix
	sub.l	d2,d0				* ix - st
	blt	vlret
*	while st <= ix do
vnlp:
	move.l	#-1,d0
	move.l	-_vn_st(a6),d2
	move.l	-_vn_ix(a6),d1
	cmp.l	d1,d2
	bgt	vnret
*		tos = VecEltI(s,st,true)
		clr.l	-(a7)			* eltlow allocated in tos
		halfmark
			move.l  -_vn_s(a6),-(a7)
			move.l	-_vn_st(a6),-(a7)
			lea.l	MARKBYTS+LNGBYTS(a7),a6
			move.l	d0,-(a7)	* -1 works as true
			lea.l	VecEltI,a0
			jsr	(a0)
		unmark				* elt allocated in tos
*		if elt == mch then 
		move.l	-_vn_elt(a6),d0
		cmp.l	-_vn_mch(a6),d0
		bne	vn2
*			if elsz == VEC_ELSZ_DBL then
			move.l	-_vn_elsz(a6),d0
			cmpi.l	#VEC_ELSZ_DBL,d0
			bne	vnfnd
*				if tos+ <> mchlow then goto vn2
				move.l 	-_vn_eltlow,d0
				cmp.l	-_vn_mchlow(a6),d0
				bne	vn2
*			endif
vnfnd:
*			d0 = st
			move.l	-_vn_st(a6),d0
*			goto vnret
			bra	vnret
*		endif
vn2:
*		drop;drop			* deallocate eltlow, elt
		lea.l	LNGBYTS+LNGBYTS(a7),a7
*
*		st ++
		move.l	-_vn_st(a6),d0
		addq.l	#1,d0
		move.l	d0,-_vn_st(a6)
*	endwhile
	bra	vnlp
vnret:
	move.l	d0,(a6)
	move.l	_vn_RetPC,a0
	jmp	(a0)
*
*
* ================ VecSubIx(s:vecptr,t: vecptr): long ==========================
VecSubIx:	* Alters a0,a1,d0,d1,d2, null OK, dbls OK
*   	If s is null or empty vec then returns -1; if t is null or empty then returns 0
*   	If s is not null and t is not embedded in s then returns -1
*   	If s is not null and t is embedded in s then returns ix of 
*	first elt of t in first instance in s.
	OFFSET	0
_vs_Result	DS.L	1
_vs_Prv		DS.L	1
_vs_s		DS.L	1
_vs_t		DS.L	1
_vs_RetPC	DS.L	1
_vs_ixs		DS.L	1
_vs_ixt		DS.L	1
_vs_si		DS.L	1
_vs_ti		DS.L	1
_vs_sbase	DS.L	1
_vs_elslow	DS.L	1
_vs_els		DS.L	1
_vs_eltlow	DS.L	1
_vs_elt		DS.L	1
	ORG	*
*
*	Result = -1
	move.l	#-1,-_vs_Result(a6)
*	if s == null then return result
	move.l	-_vs_s(a6),d0
	beq	vsret
*
*	ixs = VecCurIx(s)
	halfmark
	 	move.l	-_vs_s(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
	 	lea.l	VecCurIx,a0
	 	jsr	(a0)
	unmark					* ixs allocated in tos
*	if ixs < 0 then goto vsret
	tst.l	(a7)
	blt	vsret
*
*	Result = 0
	clr.l	-_vs_Result(a6)
*
*	if t == null then return 0
	move.l	-_vs_t(a6),d0
	beq	vsret
*
*	ixt = VecCurIx(t)
	halfmark
		move.l	-_vs_t(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark					* ixt allocated in tos
*	if ixt < 0 then goto vsret
	tst.l	(a7)
	blt 	vsret
*
*	si = 0
	clr.l	-(a7)				* si allocated in tos
*	ti = 0
	clr.l	-(a7)				* ti allocated in tos
*	sbase = 0
	clr.l	-(a7)				* sbase allocated in tos
*	while si <= ixs and ti <= ixt do
vslp:
	move.l	-_vs_ixs(a6),d0
	move.l	-_vs_si(a6),d1
	cmp.l	d0,d1
	bgt	vsendlp
	move.l	-_vs_ixt(a6),d0
	move.l	-_vs_ti(a6),d1
	cmp.l	d0,d1
	bgt	vsendlp
*			* t up to but not including t[ti] has matched s up to s[si]
*	  elslow,els = VecEltI(s,si,true)
	  clr.l	-(a7)				* elslow allocated in tos
	  halfmark
	  	move.l	-_vs_s(a6),-(a7)
	  	move.l 	-_vs_si(a6),-(a7)
	  	lea.l	MARKBYTS+LNGBYTS(a7),a6
	  	move.l	#1,-(a7)
	  	lea.l	VecEltI,a0
	  	jsr	(a0)
	  unmark				* els allocated in tos
*	  eltlow,elt = VecEltI(t,ti,true)
	  clr.l	-(a7)				* eltlow allocated in tos
	  halfmark
	  	move.l	-_vs_t(a6),-(a7)
	  	move.l	-_vs_ti(a6),-(a7)
	  	lea.l	MARKBYTS+LNGBYTS(a7),a6
	  	move.l	#1,-(a7)
	  	lea.l	VecEltI,a0
	  	jsr	(a0)
	  unmark				* elt allocated in tos
*	  if els = elt and elslow = eltlow then
	  move.l -_vs_els(a6),d0 
	  move.l -_vs_elt(a6),d1
	  cmp.l	d0,d1
	  bne	vs1
	  move.l -_vs_elslow(a6),d0
	  move.l -_vs_eltlow(a6),d1
	  cmp.l	d0,d1
	  bne 	vs1
*		si ++
		move.l	-_vs_si(a6),d0
		addq.l	#1,d0
		move.l	d0,-_vs_si(a6)
*		ti ++
		move.l	-_vs_ti(a6),d0
		addq.l	#1,d0
		move.l	d0,-_vs_ti(a6)
*	  else
	  bra	vs2
vs1:
*		sbase = sbase + 1
		move.l	-_vs_sbase(a6),d0
		addq.l	#1,d0
		move.l	d0,-_vs_sbase(a6)
*		si = sbase
		move.l	d0,-_vs_si(a6)
*		ti = 0
		clr.l	-_vs_ti(a6)
*	  endif
vs2:
	  lea.l	4*LNGBYTS(a7),a7		* deallocate elslow,els,eltlow,elt
*	endwhile
	bra vslp
vsendlp:
*	if ti > ixt then retval = -1
	move.l	-_vs_ti(a6),d0
	move.l	-_vs_ixt(a6),d1
	move.l	#-1,-_vs_Result(a6)
	cmp.l 	d1,d0
	ble	vsret
*		retval = sbase
		move.l	-_vs_sbase(a6),-_vs_Result(a6)
*	endif
vsret:
*	move.l	-_vs_RetPC(a6),a0
	jmp	(a0)
*
*
* ============= VecCat(s1:vecptr,s2:vecptr,drops1null:bool):vecptr ================
VecCat:
*   Returns new vector consisting of all elements in s1 followed by all elements in s2.
*   If s1 is null and s2 is null then returns zero. If s1 is null and s2 isn't then returns s2.
*   If s2 is null and s1 isn't then returns s1. If elsz1 <> elsz2 then returns zero.
*
	OFFSET	0
_vct_Result	DS.L	1
_vct_PrevFrm	DS.L	1
_vct_s1		DS.L	1
_vct_s2		DS.L	1
_vct_drops1null	DS.L	1
_vct_RetPC	DS.L	1
_vct_ix1	DS.L	1
_vct_ix2	DS.L	1
_vct_ixn	DS.L	1
_vct_elsz1	DS.L	1
_vct_elsz2	DS.L	1
_vct_dclwds	DS.L	1
_vct_i		DS.L	1
_vct_eltlow	DS.L	1
_vct_elt	DS.L	1
	ORG	*
*
*	ix1 = VecCurIx(s1)
	halfmark
		move.l	-_vct_s1(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark				* ix1 allocated on tos
*	ix2 = VecCurIx(s2)
	halfmark
		move.l	-_vct_s2(a6),-(a7)
		lea.l	MARKBYTS(a7),a6
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark				* ix2 allocated on tos
*
*	ixn = ix1+ix2
	move.l	LNGBYTS(a7),d0		* ix1
	move.l	d0,d1
	move.l	(a7),d2			* ix2
	add.l	d2,d0
	move.l	d0,-(a7)		* ixn allocated on tos
*	
*	if ix1 < 0 then
	tst.l	d1
	bge	vct1
*	  if ix2 < 0 then
	  tst.l	d2
	  bge	vct3
*		result = 0
		clr.l	-_vct_Result(a6)
*	  else 
	  bra	vct4
vct3:
*		result = s2
		move.l	-_vct_s2(a6),-_vct_Result(a6)
vct4:
*	else
	bra	vct2
vct1:
*	  if ix2 < 0 then
	  tst.l	d2
	  bge	vct5
*		result = s1
		move.l	-_vct_s1(a6),-_vct_Result(a6)
*	  else
	  bra	vct2
vct5:
*		elsz1 = VecElSz(s1)
		halfmark
			move.l	-_vct_s1(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	VecElSz,a0
			jsr	(a0)	
		unmark						* elsz1 allocated in tos
*		elsz2 = VecElSz(s2)
		halfmark
			move.l	-_vct_s2(a6),-(a7)
			lea.l	MARKBYTS(a7),a6
			lea.l	VecElSz,a0
			jsr	(a0)	
		unmark						* elsz2 allocated in tos
		
*		if elsz1 <> elsz2 then
		move.l	(a7),d0
		cmp.l	LNGBYTS(a7),d0
		beq	vct7
*			result = 0
			clr.l	-_vct_Result(a6)
*		else
		bra	vct2
vct7:
*			ixn = ix1 + ix2
			move.l	-_vct_ix1(a6),d0
			add.l	-_vct_ix2(a6),d0
			addq.l	#2,d0				* both ix's were zero-rel
			move.l	d0,-_vct_ixn(a6)		* ixn is 1-rel cnt now
*
*			dclwds = VecCalcDWSz(ixn,elsz1)
			halfmark
				move.l	d0,-(a7)
				move.l	-_vct_elsz1(a6),-(a7)
				lea.l	MARKBYTS+LNGBYTS(a7),a6
				lea.l	VecCalcDWSz,a0
				jsr	(a0)
			unmark					* dclwds allocated in tos
*
*			ixn --					* ixn is 0-rel ix now
			move.l	-_vct_ixn(a6),d0
			subq.l	#1,d0
			move.l	d0,-_vct_ixn(a6)
*
*			result = Vecnew(null,a2,dclwds,elsz1,ixn)
			halfmark
				clr.l	-(a7)
				move.l	a2,-(a7)
				move.l	-_vct_dclwds(a6),-(a7)
				move.l	-_vct_elsz1(a6),-(a7)
				move.l	-_vct_ixn(a6),-(a7)
				lea.l	MARKBYTS+4*LNGBYTS(a7),a6
				lea.l	VecNew,a0
				jsr	(a0)
			unmark				
			move.l	(a7)+,d0
			move.l	d0,-_vct_Result(a6)		* newvector in result
*
*			drop = VecSetCurIx(tos+,-1)
			mark
				move.l	d0,-(a7)		* newv
				move.l	#-1,-(a7)		* -1
				lea.l	VecSetCurIx,a0
				jsr	(a0)
			unmarkdrop	
*
*			i=0
			clr.l	-(a7)				* i allocated in tos
*			repeat
vct9:
*				if elsz1 == dbl then
				move.l	-_vct_elsz1(a6),d0
				cmpi.l	#VEC_ELSZ_DBL,d0
				bne	vct9a
*					push	0		* elt low order allocated on tos
					clr.l	-(a7)
vct9a:				
*				endif
*				elt = VecEltI(s1,i,true)
				halfmark
					move.l	-_vct_s1(a6),-(a7)
					move.l	-_vct_i(a6),-(a7)
					lea.l	MARKBYTS+LNGBYTS(a7),a6
					move.l	#1,-(a7)
					lea.l	VecEltI,a0
					jsr	(a0)
				unmark				* elt allocated in tos
				move.l	(a7),d0
				move.l	d0,-_vct_elt(a6)
*				if elsz1 == dbl then
				move.l	-_vct_elsz1(a6),d0
				cmpi.l	#VEC_ELSZ_DBL,d0
				bne	vct9b
*					eltlow = tos-1
					move.l	LNGBYTS(a7),-_vct_eltlow (a6)
*				endif
vct9b:
*
*				i ++
				move.l	-_vct_i(a6),d0
				addq.l	#1,d0
				move.l	d0,-_vct_i(a6)
*
*				unless (d0=null and drops1trailnull and i >= ix1) do
*					drop = VecAppend(retval,elt)
				move.l	-_vct_elt(a6),d0
				bne	vct11
				move.l	-_vct_elsz1(a6),d0
				cmpi.l	#VEC_ELSZ_DBL,d0
				bne	vct9c
					move.l	-_vct_eltlow(a6),d0
					bne	vct11
vct9c:
				tst.l	-_vct_drops1null(a6)
				beq	vct11
				move.l	-_vct_i(a6),d0
				move.l	-_vct_ix1(a6),d1
				cmp.l	d0,d1
				bge	vct12
vct11:
					halfmark
						move.l	-_vct_Result(a6),-(a7)
						move.l	-_vct_elsz1(a6),d0
						clr.l	d1
						cmpi.l	#VEC_ELSZ_DBL,d0
						bne	vct11a
							move.l	-_vct_eltlow(a6),d1
vct11a:
						move.l	d1,-(a7)		* loworder
						move.l	-_vct_elt(a6),-(a7)
						lea.l	MARKBYTS+LNGBYTS+LNGBYTS(a7),a6
						lea.l	VecAppend,a0
						jsr	(a0)
					unmarkdrop
*				endunless	
vct12:				
*			drop elt
			lea.l	LNGBYTS(a7),a7
*			if elsz1 == dbl then
			move.l	-_vct_elsz1(a6),d0
			cmpi.l	#VEC_ELSZ_DBL,d0
			bne	vct12a
*				drop eltlow
				lea.l	LNGBYTS(a7),a7
*			endif
vct12a:
*			until i >= ix1
			move.l	-_vct_i(a6),d0
			move.l	-_vct_ix1(a6),d1
			cmp.l	d1,d0
			blt	vct9	
*	
*			i = 0
			clr.l	-_vct_i(a6)
*			repeat
vct10:
*				if eltsz1 == dbl then 
				move.l	-_vct_elsz1(a6),d0
				cmpi.l	#VEC_ELSZ_DBL,d0
				bne	vct10a
*					push 0			* eltlow
					clr.l	-(a7)
*				endif
vct10a:
*				d0 = VecEltI(s2,i,true)
				halfmark
					move.l	-_vct_s2(a6),-(a7)
					move.l	-_vct_i(a6),-(a7)
					lea.l	MARKBYTS+LNGBYTS(a7),a6
					move.l	#1,-(a7)
					lea.l	VecEltI,a0
					jsr	(a0)
				unmark
*				d0 = tos+
				move.l	(a7)+,d0
*
*				if eltsz1 == dbl then
				move.l	-_vct_elsz1(a6),d1
				cmpi.l	#VEC_ELSZ_DBL,d1
				bne	vct10b
*					d1 = tos+
					move.l	(a7)+,d1
*				endif
vct10b:

*				drop = VecAppend(result,d0)
				halfmark
					move.l	-_vct_Result(a6),-(a7)
					clr.l	-(a7)
					move.l	-_vct_elsz1(a6),d2
					cmpi.l	#VEC_ELSZ_DBL,d2
					bne	vct10c
						move.l	d1,(a7)
vct10c:
					lea.l	MARKBYTS+LNGBYTS(a7),a6
					move.l	d0,-(a7)
					lea.l	VecAppend,a0
					jsr	(a0)
				unmarkdrop
*
*				i = i + 1
				move.l	-_vct_i(a6),d0
				addq.l	#1,d0
				move.l	d0,-_vct_i(a6)
*			until i > ix2
			move.l	-_vct_ix2(a6),d1
			cmp.l	d1,d0
			ble	vct10
*
*		endif
*	  endif
*	endif
vct2:
*	return result
	move.l	-_vct_RetPC(a6),a0
	jmp	(a0)
*
*
* =============== VecCmp(s1,s2:vecptr):long -1,0,1 for less,eql,grtr ===============
VecCmp:
	OFFSET	0
_vcm_Result	DS.L	1
_vcm_PrevFrm	DS.L	1
_vcm_s1		DS.L	1
_vcm_s2		DS.L	1
_vcm_RetPC	DS.L	1
_vcm_elsz1	DS.L	1
_vcm_elsz2	DS.L	1
_vcm_len1	DS.L	1
_vcm_len2	DS.L	1
_vcm_tlen	DS.L	1
_vcm_i		DS.L	1
_vcm_loworder1	DS.L	1
_vcm_s1i	DS.L	1
_vcm_loworder2	DS.L	1
_vcm_s2i	DS.l	1
	ORG	*
*   result = 0
    clr.l	-_vcm_Result(a6)
*   If s1 is null then 
    move.l	-_vcm_s1(a6),d0
    bne		vcm1
*	if s2 is null then
	move.l	-_vcm_s2(a6),d1
	bne	vcmretm1	
*		return result
		bra	vcmret
*	else
vcmretm1: 
*		return -1
		move.l	#-1,-_vcm_Result(a6)
		bra	vcmret
*	endif
*   else
vcm1:
*	if s2 is null then
	move.l	-_vcm_s2(a6),d1
	bne 	vcm2 
vcmret1:
*		return 1
		move.l	#1,-_vcm_Result(a6)
		bra	vcmret
*	endif
*   endif
vcm2:
*
*   elsz1 = VecElSz(s1)
    halfmark
    	move.l	-_vcm_s1(a6),-(a7)
    	lea.l	MARKBYTS(a7),a6
    	lea.l	VecElSz,a0
    	jsr	(a0)
    unmark				* elsz1 allocated in tos
*   elsz2 = VecElSz(s2)
    halfmark
    	move.l	-_vcm_s2(a6),-(a7)
    	lea.l	MARKBYTS(a7),a6
    	lea.l	VecElSz,a0
    	jsr	(a0)
    unmark				* elsz2 allocated in tos
*   if elsz1 <> elsz2 then
    move.l	(a7),d0
    cmp.l	LNGBYTS(a7),d0
    beq		vcm3 
*	return -2
	move.l	#-2,-_vcm_Result(a6)
	bra	vcmret
*   endif
vcm3:
*
*   len1 =VecCurIx(s1)
    halfmark
    	move.l	-_vcm_s1(a6),-(a7)
    	lea.l	MARKBYTS(a7),a6
    	lea.l	VecCurIx,a0
    	jsr	(a0)
    unmark				* len1 allocated in tos
*   len2 = VecCurIx(s2)
    halfmark
    	move.l	-_vcm_s2(a6),-(a7)
    	lea.l	MARKBYTS(a7),a6
    	lea.l	VecCurIx,a0
    	jsr	(a0)
    unmark				* len2 allocated in tos
*
*   if len1 < 0 then
    tst.l	-_vcm_len1(a6)
    bge		vcm4
*	if len2 < 0 then return 0
	tst.l	-_vcm_len2(a6)
	blt	vcmret
*	else return -1
	bra	vcmretm1
*	elsif len2 < 0 then return 1
vcm4:
	tst.l	-_vcm_len2(a6)
	blt	vcmret1
*   endif	* know len1 >= 0 and len2 >=0
*
*   tlen = min(len1,len2)
    move.l	-_vcm_len2(a6),d0
    move.l	-_vcm_len1(a6),d1
    move.l	d1,-(a7)		* tlen allocated in tos
    cmp.l	d0,d1
    ble		vcm5 
	move.l	d0,-_vcm_tlen(a6) 
vcm5:
*
*   i=0
    clr.l	-(a7) 			* i allocated in tos
*   while i <= tlen do
vcm6:
    move.l	-_vcm_i(a6),d0
    move.l	-_vcm_tlen(a6),d1
    cmp.l	d0,d1
    blt		vcm7   
*	s1i = VecEltI(s1,i,true)
	clr.l	-(a7)				* loworder1 allocated in tos
	halfmark
		move.l	-_vcm_s1(a6),-(a7)
		move.l	-_vcm_i(a6),-(a7)
		lea.l	MARKBYTS+LNGBYTS(a7),a6
		move.l	#1,-(a7)
		lea.l	VecEltI,a0
		jsr	(a0)
	unmark 					* s1i allocated in tos
	clr.l	-(a7)				* loworder2 allocated in tos
*	s2i = VecEltI(s2,i,true)
	halfmark
		move.l	-_vcm_s2(a6),-(a7)
		move.l	-_vcm_i(a6),-(a7)
		lea.l	MARKBYTS+LNGBYTS(a7),a6
		move.l	#1,-(a7)
		lea.l	VecEltI,a0
		jsr	(a0)
	unmark					* s2i
*	if s1i < s2i then return -1
	move.l	-_vcm_s1i(a6),d0
	move.l	-_vcm_s2i(a6),d1
	cmp	d0,d1
	bgt	vcmretm1
*	else if s1i > s2i then return 1
	blt	vcmret1
*	else if elsz1 = dbl then
	move.l	-_vcm_elsz1(a6),d0
	cmpi.l	#VEC_ELSZ_DBL,d0
	bne	vcm8
*	    if loworder1 < loworder2 then return -1
	    move.l	-_vcm_loworder1(a6),d0
	    move.l	-_vcm_loworder2(A6),D1
	    cmp.l	d0,D1
	    bgt		vcmretm1
*	    else if loworder1 > loworder2 then return 1
	    blt		vcmret1 
*	    endif 		* keep on going
*	endif
vcm8:
*	drop;drop;drop;drop	* deallocate loworder1, s1i, loworder2 and s2i
	lea.l	4*LNGBYTS(a7),a7
*	i++
	move.l	-_vcm_i(a6),d0
	addq.l	#1,d0
	move.l	d0,-_vcm_i(a6)
*   endwhile
    bra		vcm6
vcm7:

*   if len1 < len2 then return -1
    move.l	-_vcm_len1(a6),d0
    move.l	-_vcm_len2(a6),d1
    cmp.l	d0,d1
    bgt		vcmretm1 
*   else if len1 > len2 then return 1
    blt		vcmret1
*   else return 0
vcmret:
    move.l	-_vcm_RetPC(a6),a0
    jmp		(a0)
* endfn
*
*
*	==== VecAppend ( v: vecptr, eltlow: long, elt: long ): vecptr =============
VecAppend:
	OFFSET	0
_va_Result	DS.L	1
_va_PrvFrm	DS.L	1
_va_v		DS.L	1
_va_eltlow	DS.L	1
_va_elt		DS.L	1
_va_RetPC	DS.L	1
_va_i		DS.L	1
_va_m		DS.L	1
_va_typ		DS.L	1
	ORG	*
*
*	if v=null then return v
	move.l	-_va_v(a6),-_va_Result(a6)
	beq	va6
	halfmark
		move.l	-_va_v(a6),-(a7)	* v
		lea.l	MARKBYTS(a7),a6		* New Frm
		lea.l	VecCurIx,a0
		jsr	(a0)
	unmark					* i allocated in tos
	halfmark
		move.l	-_va_v(a6),-(a7)	* v
		lea.l	MARKBYTS(a7),a6		* New Frm
		lea.l	VecDclWdSz,a0
		jsr	(a0)
	unmark					
	subq.l	#VEC_HDR_WDS,(a7)		* m allocated in tos
	halfmark
		move.l	-_va_v(a6),-(a7)
		lea.l	MARKBYTS(a7),a6		* New Frm
		lea.l	VecElSz,a0
		jsr	(a0)
	unmark					
	move.l	(a7),d1				* typ allocated in tos
	move.l	-_va_m(a6),d0			* m
	cmpi.l	#VEC_ELSZ_BYT,d1
	bne	va0
		add.l	d0,d0			* m becomes byte count
	bra	va2
va0:
	cmp.l	#VEC_ELSZ_LNG,d1
	bne	va1
		asr.l	#1,d0			* m becomes long count
	bra	va2
va1:
	cmp.l	#VEC_ELSZ_DBL,d1
	bne	va2
		asr.l	#2,d0			* m becomes dbl count
va2:
	subq.l	#1,d0
	move.l	d0,-_va_m(a6)			* m is now inx
*	if i < m then
	move.l	-_va_i(a6),d1
	cmp.l	d0,d1
	bge	va6
*		Only update v if there's room
		halfmark
			addq.l	#1,d1
			move.l	d1,-_va_i(a6)    * update local i
			move.l	-_va_v(a6),-(a7) * v
			lea.l	MARKBYTS(a7),a6         * new frm ptr
			move.l	d1,-(a7)	 * i
			lea.l	VecSetCurIx,a0
			jsr	(a0)
		unmark				* v in tos
		halfmark
			move.l	-_va_v(a6),-(a7) * copy v down
			move.l	-_va_i(a6),-(a7) * i
			lea.l	MARKBYTS+LNGBYTS(a7),a6	* new frm ptr
			clr.l	-(a7)		* val=false since want addr
			lea.l	VecEltI,a0
			jsr	(a0)
		unmark				* addr of elt in tos
		move.l	(a7)+,a0		* v in tos
		move.l	-_va_typ(a6),d1
		cmpi.l	#VEC_ELSZ_BYT,d1
		bne	va3
			move.b	-_va_elt+LNGBYTS-1(a6),(a0)	* store elt
		bra	va6
va3:
		cmpi.l	#VEC_ELSZ_WRD,d1
		bne	va4
			move.w	-_va_elt+LNGWRDS-1(a6),(a0)	* store elt
		bra	va6
va4:
		cmpi.l	#VEC_ELSZ_LNG,d1
		bne	va5
			move.l	-_va_elt(a6),(a0)	* store elt
		bra	va6
va5:
		move.l	-_va_elt(a6),(a0)+
		move.l	-_va_eltlow(a6),(a0)		* store elt
va6:
		move.l	-_va_v(a6),-_va_Result(a6)	* return v
		move.l	-_va_RetPC(a6),a0
		jmp	(a0)
*
		ORG	(*+3)&-4
*
*	============================= Name Vectors =====================
_VecPrev	DC.L	_PrtDispKey
		DC.W	8
		DC.W	7
		DC.B	'_VecPrv',0
*
_VecLast	DC.L	_VecPrev
		DC.W	8
		DC.W	7
		DC.B	'_VecLst',0
*
_VECBYT		DC.L	_VecLast
		DC.W	8
		DC.W	7
		DC.B	'_VECBYT',0
*
_VECWRD		DC.L	_VECBYT
		DC.W	8
		DC.W	7
		DC.B	'_VECWRD',0
*
_VECLNG		DC.L	_VECWRD
		DC.W	8
		DC.W	7
		DC.B	'_VECLNG',0
*
_VECDBL		DC.L	_VECLNG
		DC.W	8
		DC.W	7
		DC.B	'_VECDBL',0
*
_VecDclWdSz	DC.L	_VECDBL
		DC.W	12
		DC.W	11
		DC.B	'_VecDclWdSz',0,0,0,0,0
*
_VecCalcDWSz	DC.L	_VecDclWdSz
		DC.W	12
		DC.W	12
		DC.B	'_VecCalcDWSz',0,0,0,0
*
_VecElSz	DC.L	_VecCalcDWSz
		DC.W	12
		DC.W	8
		DC.B	'_VecElSz',0,0,0,0,0,0,0,0
*
_VecMaxIx	DC.L	_VecElSz
		DC.W	12
		DC.W	9
		DC.B	'_VecMaxIx',0,0,0,0,0,0,0
*
_VecCurIx	DC.L	_VecMaxIx
		DC.W	12
		DC.W	9
		DC.B	'_VecCurIx',0,0,0,0,0,0,0
*
_VecSetCurIx	DC.L	_VecCurIx
		DC.W	12
		DC.W	12
		DC.B	'_VecSetCurIx',0,0,0,0
*
_VecEltI	DC.L	_VecSetCurIx
		DC.W	12
		DC.W	8
		DC.B	'_VecEltI',0,0,0,0,0,0,0,0
*
_VecNew		DC.L	_VecEltI
		DC.W	8
		DC.W	7
		DC.B	'_VecNew',0
*
_VecCpy	DC.L	_VecNew
		DC.W	8
		DC.W	7
		DC.B	'_VecCpy',0
*
_VecMid		DC.L	_VecCpy
		DC.W	8
		DC.W	7
		DC.B	'_VecMid',0
*
_VecNxt		DC.L	_VecMid
		DC.W	8
		DC.W	7
		DC.B	'_VecNxt',0
*
_VecSubIx	DC.L	_VecNxt
		DC.W	12
		DC.W	9
		DC.B	'_VecSubIx',0,0,0,0,0,0,0
*
_VecCat		DC.L	_VecSubIx
		DC.W	8
		DC.W	7
		DC.B	'_VecCat',0
*
_VecCmp		DC.L	_VecCat
		DC.W	8
		DC.W	7
		DC.B	'_VecCmp',0
*
_VecAppend	DC.L	_VecCmp
		DC.W	12
		DC.W	10
		DC.B	'_VecAppend',0,0,0,0,0,0
*
*	==================== Dic Entries ================================
__VecPrev	DC.L	__PrtDispKey
		DC.L	_VecPrev
		DC.L	VecPrev
*
__VecLast	DC.L	__VecPrev
		DC.L	_VecLast
		DC.L	VecLast
*
__VECBYT	DC.L	__VecLast
		DC.L	_VECBYT
		DC.L	Vec_ELSZ_BYT
*
__VECWRD	DC.L	__VECBYT
		DC.L	_VECWRD
		DC.L	Vec_ELSZ_WRD
*
__VECLNG	DC.L	__VECWRD
		DC.L	_VECLNG
		DC.L	Vec_ELSZ_LNG
*
__VECDBL	DC.L	__VECLNG
		DC.L	_VECDBL
		DC.L	Vec_ELSZ_DBL
*
__VecDclWdSz	DC.L	__VECDBL	
		DC.L	_VecDclWdSz
		DC.L	VecDclWdSz

__VecCalcDWSz	DC.L	__VecDclWdSz
		DC.L	_VecCalcDWSz
		DC.L	VecCalcDWSz
*
__VecElSz	DC.L	__VecCalcDWSz
		DC.L	_VecElSz
		DC.L	VecElSz
*
__VecMaxIx	DC.L	__VecElSz
		DC.L	_VecMaxIx
		DC.L	VecMaxIx
*
__VecCurIx	DC.L	__VecMaxIx
		DC.L	_VecCurIx
		DC.L	VecCurIx
*
__VecSetCurIx	DC.L	__VecCurIx
		DC.L	_VecSetCurIx
		DC.L	VecSetCurIx
*
__VecEltI	DC.L	__VecSetCurIx
		DC.L	_VecEltI
		DC.L	VecEltI
*
__VecNew	DC.L	__VecEltI
		DC.L	_VecNew
		DC.L	VecNew
*
__VecCpy	DC.L	__VecNew
		DC.L	_VecCpy
		DC.L	VecCpy
*
__VecMid	DC.L	__VecCpy
		DC.L	_VecMid
		DC.L	VecMid
*
__VecNxt	DC.L	__VecMid
		DC.L	_VecNxt
		DC.L	VecNxt
*
__VecSubIx	DC.L	__VecNxt
		DC.L	_VecSubIx
		DC.L	VecSubIx
*
__VecCat	DC.L	__VecSubIx
		DC.L	_VecCat
		DC.L	VecCat
*
__VecCmp	DC.L	__VecCat
		DC.L	_VecCmp
		DC.L	VecCmp
*
*
__VecAppend	DC.L	__VecCmp
		DC.L	_VecAppend
		DC.L	VecAppend		
*
	
	































































































































































*~Font name~Courier New~
*~Font size~10~
*~Tab type~1~
*~Tab size~8~
